<?php
/**
 * Jewelry Blocks: Block Patterns
 *
 * @since Jewelry Blocks 1.0
 */

/**
 * Registers block patterns and categories.
 *
 * @since Jewelry Blocks 1.0
 *
 * @return void
 */
function jewelry_blocks_register_block_patterns() {
	$jewelry_blocks_block_pattern_categories = array(
		'jewelry-blocks'    => array( 'label' => __( 'Jewelry Blocks', 'jewelry-blocks' ) ),
	);

	$jewelry_blocks_block_pattern_categories = apply_filters( 'jewelry_blocks_block_pattern_categories', $jewelry_blocks_block_pattern_categories );

	foreach ( $jewelry_blocks_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'jewelry_blocks_register_block_patterns', 9 );
