<?php 

function jewelry_blocks_add_admin_menu() {
    add_menu_page(
        'Theme Settings', // Page title
        'Theme Settings', // Menu title
        'manage_options', // Capability
        'jewelry-blocks-theme-settings', // Menu slug
        'jewelry_blocks_settings_page' // Function to display the page
    );
}
add_action( 'admin_menu', 'jewelry_blocks_add_admin_menu' );

function jewelry_blocks_settings_page() {
    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Theme Settings', 'jewelry-blocks' ); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields( 'jewelry_blocks_settings_group' );
            do_settings_sections( 'jewelry-blocks-theme-settings' );
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

function jewelry_blocks_register_settings() {
    register_setting( 'jewelry_blocks_settings_group', 'jewelry_blocks_enable_animations' );

    add_settings_section(
        'jewelry_blocks_settings_section',
        __( 'Animation Settings', 'jewelry-blocks' ),
        null,
        'jewelry-blocks-theme-settings'
    );

    add_settings_field(
        'jewelry_blocks_enable_animations',
        __( 'Enable Animations', 'jewelry-blocks' ),
        'jewelry_blocks_enable_animations_callback',
        'jewelry-blocks-theme-settings',
        'jewelry_blocks_settings_section'
    );
}
add_action( 'admin_init', 'jewelry_blocks_register_settings' );

function jewelry_blocks_enable_animations_callback() {
    $checked = get_option( 'jewelry_blocks_enable_animations', true );
    ?>
    <input type="checkbox" name="jewelry_blocks_enable_animations" value="1" <?php checked( 1, $checked ); ?> />
    <?php
}

