<?php
/**
 * Jewelry Blocks: Customizer
 *
 * @subpackage Jewelry Blocks
 * @since 1.0
 */

function jewelry_blocks_customize_register( $wp_customize ) {

	wp_enqueue_style('customizercustom_css', esc_url( get_template_directory_uri() ). '/inc/customizer/customizer.css');

	// Pro Section
 	$wp_customize->add_section('jewelry_blocks_pro', array(
        'title'    => __('JEWELRY BLOCKS PREMIUM', 'jewelry-blocks'),
        'priority' => 1,
    ));
    $wp_customize->add_setting('jewelry_blocks_pro', array(
        'default'           => null,
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control(new Jewelry_Blocks_Pro_Control($wp_customize, 'jewelry_blocks_pro', array(
        'label'    => __('JEWELRY BLOCKS PREMIUM', 'jewelry-blocks'),
        'section'  => 'jewelry_blocks_pro',
        'settings' => 'jewelry_blocks_pro',
        'priority' => 1,
    )));
}
add_action( 'customize_register', 'jewelry_blocks_customize_register' );


define('JEWELRY_BLOCKS_PRO_LINK',__('https://www.ovationthemes.com/products/jeweller-wordpress-theme','jewelry-blocks'));

define('JEWELRY_BLOCKS_BUNDLE_BTN',__('https://www.ovationthemes.com/products/wordpress-bundle','jewelry-blocks'));

/* Pro control */
if (class_exists('WP_Customize_Control') && !class_exists('Jewelry_Blocks_Pro_Control')):
    class Jewelry_Blocks_Pro_Control extends WP_Customize_Control{

    public function render_content(){?>
        <label style="overflow: hidden; zoom: 1;">
	        <div class="col-md upsell-btn">
                <a href="<?php echo esc_url( JEWELRY_BLOCKS_PRO_LINK ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('UPGRADE JEWELRY BLOCKS PREMIUM','jewelry-blocks');?> </a>
	        </div>
            <div class="col-md">
                <img class="jewelry_blocks_img_responsive " src="<?php echo esc_url(get_template_directory_uri()); ?>/screenshot.png">
            </div>
	        <div class="col-md">
                <ul style="padding-top:10px">
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'jewelry-blocks');?> </li>                 
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'jewelry-blocks');?> </li>
                    <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'jewelry-blocks');?> </li>
                </ul>
        	</div>
            <div class="col-md upsell-btn upsell-btn-bottom">
                <a href="<?php echo esc_url( JEWELRY_BLOCKS_BUNDLE_BTN ); ?>" target="blank" class="btn btn-success btn"><?php esc_html_e('WP Theme Bundle (125+ Themes)','jewelry-blocks');?> </a>
            </div>
        </label>
    <?php } }
endif;