<?php 

$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

do_action( 'jewelry_store_before_site_end' ); ?>

<?php
        $column = absint( $option['footer_column_layout'] );

        $max_cols = 12;
        $layouts = 12;
        if ( $column > 1 ){
            $default = "12";
            switch ( $column ) {
                case 4:
                    $default = '3+3+3+3';
                    break;
                case 3:
                    $default = '4+4+4';
                    break;
                case 2:
                    $default = '6+6';
                    break;
            }
            $layouts = sanitize_text_field( isset($option['footer_custom_'.$column.'_columns'])?$option['footer_custom_'.$column.'_columns']:$default );
        }

        $layouts = explode( '+', $layouts );
        foreach ( $layouts as $k => $v ) {
            $v = absint( trim( $v ) );
            $v =  $v >= $max_cols ? $max_cols : $v;
            $layouts[ $k ] = $v;
        }

        $have_widgets = false;

        for ( $count = 0; $count < $column; $count++ ) {
            $slidebar_id = 'footer-' . ( $count + 1 );
            if ( is_active_sidebar( $slidebar_id ) ) {
                $have_widgets = true;
            }
        }

        $class = '';
        if($option['footer_back_image']){
            $class = ' has_section_bg_image';
        }
        $class = trim($class);

        $footerwidget_containerClass = '';
        if($option['footerwidget_container_width']!=''){
            $footerwidget_containerClass = $option['footerwidget_container_width'];
        }

        $footercopyright_containerClass = '';
        if($option['footercopyright_container_width']!=''){
            $footercopyright_containerClass = $option['footercopyright_container_width'];
        }
        ?>
        <footer class="footer <?php echo esc_attr($class); ?>" role="footer">
            <?php if($option['footer_back_image']){ ?>
            <div class="section_bg_container">
                <img src="<?php echo esc_url($option['footer_back_image']); ?>">
            </div>
            <?php } ?>

            <?php if ( $column > 0 && $have_widgets ) { ?>
        	<div class="footer-middle">
                <div class="<?php echo esc_attr( $footerwidget_containerClass ); ?>">
                    <div class="row">
                        <?php
                         for ( $count = 0; $count < $column; $count++ ) {
                         $col = isset( $layouts[ $count ] ) ? $layouts[ $count ] : '';
                         $slidebar_id = 'footer-' . ( $count + 1 );
                         if ( $col ) {
                        ?>
                        <div class="col-lg-<?php echo esc_attr( $col ); ?> col-md-6 col-12">
                            <?php dynamic_sidebar( $slidebar_id ); ?>
                        </div>
                        <?php 
                            }
                        } 
                        ?>
                    </div>
                </div>
        	</div>
            <?php } ?>
                
        	<div class="footer-bottom">
                <div class="<?php echo esc_attr( $footercopyright_containerClass ); ?>">
                    <div class="row">
                        <div class="col-lg-6 col-md-6 col-12 text-lg-start text-md-start text-center order-lg-1 order-md-1 order-2">
                            <p class="copyright">
                                <?php                                
                                $options = array(
                                    '[current_year]',
                                    '[copy]',
                                    '[site_title]',
                                    '[theme_author]',
                                );

                                $replace = array(
                                    esc_attr( date( 'Y' ) ),
                                    '&copy;',
                                    esc_attr( get_bloginfo() ),
                                    sprintf( 
                                        __( '<a href="%1$s">%2$s</a>','jewelry-store'),
                                        esc_url('https://www.britetechs.com/'),
                                        esc_html__('Britetechs','jewelry-store')
                                    )
                                );

                                $copyright = str_replace( $options, $replace, $option['footer_copyright_text'] );
                                echo wp_kses_post($copyright); 
                                ?>   
                            </p>
                        </div>
                        <div class="col-lg-6 col-md-6 col-12 d-flex justify-content-lg-end justify-content-md-end justify-content-center order-lg-2 order-md-2 order-1 mb-lg-0 mb-md-0 mb-3">
                            <?php 
                            if ( has_nav_menu('footer') ) { 
                                wp_nav_menu( array(
                                'theme_location' => 'footer',
                                'menu_class' => 'footer-menus',
                                'container' => 'ul',
                                ) );
                            }
                            ?>
                        </div>
                    </div>
                </div>
        	</div>
        </footer>

        </div><!-- End .site -->

        <?php if( $option['back_to_top_show'] == true ){ ?>
        <a class="back_to_top" href="#" title="<?php _e('Back To Top','jewelry-store'); ?>">
            <i class="fa fa-angle-up"></i>
        </a>
        <?php 
        }

        // Swither Print Here
        do_action('jewelry_store_footer_content');

        wp_footer(); 
        ?>
    </body>
</html>