<?php
/**
 * jewelry store functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 */

/**
 * Define Constants Variables
 */

define( 'JEWELRY_STORE_PARENT_DIR', get_template_directory() );
define( 'JEWELRY_STORE_PARENT_URI', get_template_directory_uri() );

define( 'JEWELRY_STORE_PARENT_INC_DIR', JEWELRY_STORE_PARENT_DIR . '/inc');
define( 'JEWELRY_STORE_PARENT_INC_URI', JEWELRY_STORE_PARENT_URI . '/inc');

define( 'JEWELRY_STORE_PARENT_CUSTOMIZER_DIR', JEWELRY_STORE_PARENT_INC_DIR . '/customizer');
define( 'JEWELRY_STORE_PARENT_CUSTOMIZER_URI', JEWELRY_STORE_PARENT_INC_URI . '/customizer');

if( ! function_exists( 'jewelry_store_setup' ) ):

	function jewelry_store_setup() {

		// Load theme text domain
		load_theme_textdomain( 'jewelry-store', get_template_directory() . '/languages' );
		
		// Setup automatic feeds
		add_theme_support( 'automatic-feed-links' );
		
		// Lets manage WordPress documents
		add_theme_support( 'title-tag' );
		
		add_post_type_support( 'page', 'excerpt' );
		
		// Adding featured image supports
		add_theme_support( 'post-thumbnails' );
		
		// Register theme menus
		register_nav_menus( array(
			'primary'      => esc_html__( 'Primary Menu', 'jewelry-store' ),
			'footer'      => esc_html__( 'Footer Menu', 'jewelry-store' ),
		) );
		
		// HTML 5 supports
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		/*
		 * This theme styles the visual editor to resemble the theme style,
		 * specifically font, colors, icons, and column width.
		 */
		add_editor_style( array( 'assets/css/editor-style.css', jewelry_store_fonts_url() ) );

		// Load regular editor styles into the new block-based editor.
		add_theme_support( 'editor-styles' );

		// Load default block styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for responsive embeds.
		add_theme_support( 'responsive-embeds' );

		// Gutenberg wide images.
		add_theme_support( 'align-wide' );
		
		add_theme_support( 'custom-logo', array(
            'height'      => 50,
            'width'       => 150,
            'flex-height' => true,
            'flex-width'  => true,
        ) );

		// Setup a custom header
		add_theme_support( 'custom-header' );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'jewelry_store_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );
		
		add_theme_support( 'customize-selective-refresh-widgets' );
		
		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'aside',
			'image',
			'video',
			'quote',
			'link',
			'gallery',
			'audio',
		) );

		if ( class_exists( 'WooCommerce' ) ) {
			add_theme_support( 'woocommerce' );
			add_theme_support( 'wc-product-gallery-zoom' );
			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );
		}

		// load starter Content.
		add_theme_support( 'starter-content', jewelry_store_wp_starter_pack() );
	}

 endif;
 add_action( 'after_setup_theme', 'jewelry_store_setup' );

/**
 * @global int $content_width
 */

if( ! function_exists('jewelry_store_content_width') ){

	function jewelry_store_content_width() {
		$GLOBALS['content_width'] = apply_filters( 'jewelry_store_content_width', 1296 );
	}
	add_action( 'after_setup_theme', 'jewelry_store_content_width', 0 );
}


if ( ! function_exists( 'jewelry_store_fonts_url' ) ) :

	/**
	 * Register default Google fonts
	 */
	function jewelry_store_fonts_url() {
		$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

	    $fonts_url = '';

	    $Poppins = _x( 'on', 'Poppins font: on or off', 'jewelry-store' );
	    $Playfair_Display = _x( 'on', 'Playfair Display font: on or off', 'jewelry-store' );

	    if ( 'off' !== $Poppins && 'off' !== $Playfair_Display ) {
	        $font_families = array();

	        if ( 'off' !== $Poppins ) {
	            $font_families['Poppins'] = 'Poppins:100,200,300,400,500,600,700,800,900';
	        }

	        if ( 'off' !== $Playfair_Display ) {
	            $font_families['Playfair+Display'] = 'Playfair+Display:100,200,300,400,500,600,700,800,900';
	        }

	        if( isset($option['body_font_family']) && $option['body_font_family'] != null ){
	        	$font_families[$option['body_font_family']] = $option['body_font_family'].':100,200,300,400,500,600,700,800,900';
	        }

	        for( $i = 1; $i <= 6; $i++ ){
	        	 if( isset($option['h'.$i.'_font_family']) && $option['h'.$i.'_font_family'] != null ){
		        	$font_families[$option['h'.$i.'_font_family']] = $option['h'.$i.'_font_family'].':100,200,300,400,500,600,700,800,900';
		        }
	        }
			
	        $query_args = array(
	            'family' => urlencode( implode( '|', $font_families ) ),
	            'subset' => urlencode( 'latin,latin-ext' ),
	        );

	        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	    }

	    return esc_url_raw( $fonts_url );
	}

endif;

// Default theme data file
require get_parent_theme_file_path('/inc/resetdata.php');

// Theme css and js files
require get_parent_theme_file_path('/inc/enqueue.php');

// Template tag file
require get_parent_theme_file_path('/inc/template-tags.php');

// Theme generate dynamic css file
require get_parent_theme_file_path('/inc/dynamic_style.php');

// Theme navwalker file
require get_parent_theme_file_path('/inc/theme_navwalker.php');

// Theme extra functions file
require get_parent_theme_file_path('/inc/extra.php');

// Theme widgets sidebars file
require get_parent_theme_file_path('/inc/sidebars.php');

// Theme breadcrumbs file
require get_parent_theme_file_path('/inc/breadcrumbs.php');

// Theme customizer options file
require get_parent_theme_file_path('/inc/customizer/customizer.php');

// Theme Recommanded Plugins
require get_parent_theme_file_path('/inc/install/class-install-helper.php');
require get_parent_theme_file_path('/inc/install/customizer_recommended_plugin.php');

if( file_exists( get_template_directory() .'/pro/jewelry-store-pro.php' ) ){
	require get_parent_theme_file_path('/pro/jewelry-store-pro.php');
	require get_parent_theme_file_path('/pro/inc/import-theme-data.php');
}else{
	// Theme frontpage helper functions file
	require get_parent_theme_file_path('/inc/frontpage-helper.php');
}