<?php
if( ! function_exists('jewelry_store_customizer_general_settings') ){
    function jewelry_store_customizer_general_settings( $wp_customize ){

        $option = jewelry_store_reset_data();

        $wp_customize->add_panel( 'general_section',
            array(
                'title'          => esc_html__( 'General', 'jewelry-store' ),
                'capability'     => 'edit_theme_options',
                'priority'       => 2,
            )
        );

            $wp_customize->add_section( 'layout' , array(
                'title'      => __('Site Layout', 'jewelry-store' ),
                'priority'    => 1,
                'panel'  => 'general_section',
            ) );

                // Site layout
                $wp_customize->add_setting( 'jewelrystore_option[site_layout]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_select',
                        'default'           => $option['site_layout'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[site_layout]',
                    array(
                        'type'        => 'select',
                        'label'       => esc_html__('Layout', 'jewelry-store'),
                        'section'     => 'layout',
                        'choices' => array(
                            'wide'=> __('Wide','jewelry-store'),
                            'boxed'=> __('Boxed','jewelry-store')
                            ),
                    )
                );

            $wp_customize->add_section( 'breadcrumb_section' ,
                array(
                    'priority'    => 2,
                    'title'       => esc_html__( 'Breadcrumbs', 'jewelry-store' ),
                    'panel'       => 'general_section',
                )
            );

                // Show Subheader Section
                $wp_customize->add_setting( 'jewelrystore_option[subheader_show]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['subheader_show'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 1,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[subheader_show]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show Breadcrumbs Section', 'jewelry-store'),
                        'section'     => 'breadcrumb_section',
                    )
                );

                if ( class_exists( 'Jewelry_Store_Customizer_Range_Control' ) ) {

                    $wp_customize->add_setting( 'jewelrystore_option[subheader_height]', array(
                        'default'           => $option['subheader_height'],
                        'capability'        => 'edit_theme_options',
                        'sanitize_callback' => 'jewelry_store_sanitize_range_value',
                        'type'          => 'option',
                        'priority'      => 1,
                    ) );
                    $wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[subheader_height]', 
                        array(
                            'label'      => __( 'Min Height', 'jewelry-store' ),
                            'section'  => 'breadcrumb_section',
                            'media_query'   => true,
                            'input_attr'    => array(
                                'mobile'  => array(
                                    'min'           => 0,
                                    'max'           => 1024,
                                    'step'          => 1,
                                    'default_value' => $option['subheader_height'],
                                ),
                                'tablet'  => array(
                                    'min'           => 0,
                                    'max'           => 1024,
                                    'step'          => 1,
                                    'default_value' => $option['subheader_height'],
                                ),
                                'desktop' => array(
                                    'min'           => 0,
                                    'max'           => 1024,
                                    'step'          => 1,
                                    'default_value' => $option['subheader_height'],
                                ),
                            ),
                        ) ) 
                    );

                }            

                // Container width
                $wp_customize->add_setting( 'jewelrystore_option[subheader_container_width]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_radio',
                        'default'           => $option['subheader_container_width'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 2,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[subheader_container_width]',
                    array(
                        'type'        => 'radio',
                        'label'       => esc_html__('Container Width', 'jewelry-store'),
                        'section'     => 'breadcrumb_section',
                        'choices' => array(
                            'container'=> __('Container','jewelry-store'),
                            'container-fluid'=> __('Container Full','jewelry-store')
                            ),
                    )
                );

                // Text Align
                $wp_customize->add_setting( 'jewelrystore_option[subheader_text_align]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_select',
                        'default' => $option['subheader_text_align'],
                        'transport' => 'postMessage',
                        'type' => 'option',
                        'priority'    => 3,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[subheader_text_align]',
                    array(
                        'label'       => esc_html__('Alignment', 'jewelry-store'),
                        'section'     => 'breadcrumb_section',
                        'type'        => 'select',
                        'choices'     => array(
                            'start'=> __('Left','jewelry-store'),
                            'center'=> __('Center','jewelry-store'),
                            'end'=> __('Right','jewelry-store'),
                        ),
                    )
                );

                // Overlay Color
                $wp_customize->add_setting( 'jewelrystore_option[subheader_overlay_color]',
                    array(
                        'sanitize_callback' => 'sanitize_hex_color',
                        'default'           => $option['subheader_overlay_color'],
                        'type' => 'option',
                        'priority'    => 4,
                    )
                );
                $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'jewelrystore_option[subheader_overlay_color]',
                    array(
                        'label'       => esc_html__('Overlay Color', 'jewelry-store'),
                        'section'     => 'breadcrumb_section',
                    )
                ) );

                // Color Alpha Value
                if ( class_exists( 'Jewelry_Store_Customizer_Range_Control' ) ) {

                    $wp_customize->add_setting( 'jewelrystore_option[subheader_overlay_color_opacity]', array(
                        'default'           => $option['subheader_overlay_color_opacity'],
                        'capability'        => 'edit_theme_options',
                        'sanitize_callback' => 'jewelry_store_sanitize_range_value',
                        'type'          => 'option',
                        'priority'      => 5,
                    ) );
                    $wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[subheader_overlay_color_opacity]', 
                        array(
                            'label'      => __( 'Overlay Color Opacity', 'jewelry-store' ),
                            'section'  => 'breadcrumb_section',
                            'media_query'   => false,
                            'input_attr'    => array(
                                'mobile'  => array(
                                    'min'           => 0,
                                    'max'           => 1,
                                    'step'          => 0.1,
                                    'default_value' => $option['subheader_overlay_color_opacity'],
                                ),
                                'tablet'  => array(
                                    'min'           => 0,
                                    'max'           => 1,
                                    'step'          => 0.1,
                                    'default_value' => $option['subheader_overlay_color_opacity'],
                                ),
                                'desktop' => array(
                                    'min'           => 0,
                                    'max'           => 1,
                                    'step'          => 0.1,
                                    'default_value' => $option['subheader_overlay_color_opacity'],
                                ),
                            ),
                        ) ) 
                    );

                }

                // Breadcrumbs Background Image
                $wp_customize->add_setting( 'jewelrystore_option[subheader_bg_image]',
                    array(
                        'sanitize_callback' => 'esc_url_raw',
                        'default'           => $option['subheader_bg_image'],
                        'type' => 'option',
                        'priority'    => 6,
                    )
                );
                $wp_customize->add_control( new WP_Customize_Image_Control(
                    $wp_customize,
                    'jewelrystore_option[subheader_bg_image]',
                    array(
                        'label'         => esc_html__('Background image', 'jewelry-store'),
                        'section'       => 'breadcrumb_section',
                        'settings'       => 'jewelrystore_option[subheader_bg_image]',
                    )
                ));

                // Breadcrumbs Background Image Attachment
                $wp_customize->add_setting( 'jewelrystore_option[subheader_bg_attachment]', array(
                    'default'           => $option['subheader_bg_attachment'],
                    'capability'        => 'edit_theme_options',
                    'sanitize_callback' => 'jewelry_store_sanitize_select',
                    'type' => 'option',
                    'priority'    => 7,
                ) );
                $wp_customize->add_control( 'jewelrystore_option[subheader_bg_attachment]', array(
                    'label'      => __( 'Background Attachment', 'jewelry-store' ),
                    'section'  => 'breadcrumb_section',
                    'type'        => 'select',
                    'choices'     =>  array(
                        'inherit'       =>  __( 'Inherit', 'jewelry-store' ),
                        'scroll'     =>  __( 'Scroll', 'jewelry-store' ),
                        'fixed'     =>  __( 'Fixed', 'jewelry-store' ),
                ) ) );
    }
}
add_action('customize_register','jewelry_store_customizer_general_settings');