<?php
function jewelry_store_customizer_contact( $wp_customize ){

	$option = jewelry_store_reset_data();

		$wp_customize->add_section( 'contact_section' ,
			array(
				'priority'    => 55,
				'title'       => esc_html__( 'Contact', 'jewelry-store' ),
				'panel'       => 'frontpage',
			)
		);
			$wp_customize->add_setting( 'jewelrystore_option[contact_enable]',
				array(
					'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
					'default'           => $option['contact_enable'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_enable]',
				array(
					'type'        => 'checkbox',
					'label'       => esc_html__('Contact Enable', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_subtitle]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_subtitle'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_subtitle]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Subtitle', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_title]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_title'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_title]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Title', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_desc]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_desc'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_desc]',
				array(
					'type'        => 'textarea',
					'label'       => esc_html__('Description', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_container_width]',
                array(
                    'sanitize_callback' => 'jewelry_store_sanitize_radio',
                    'default'           => $option['contact_container_width'],
                    'transport'			=> 'postMessage',
                    'type' => 'option',
                )
            );
            $wp_customize->add_control( 'jewelrystore_option[contact_container_width]',
                array(
                    'type'        => 'radio',
                    'label'       => esc_html__('Container Width', 'jewelry-store'),
                    'section'     => 'contact_section',
                    'choices' => array(
                    	'container'=> __('Container','jewelry-store'),
                    	'container-fluid'=> __('Container Full','jewelry-store')
                    	),
                )
            );            

			$wp_customize->add_setting( 'jewelrystore_option[contact_shortcode]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_shortcode'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_shortcode]',
				array(
					'type'        => 'textarea',
					'label'       => esc_html__('Contact Form 7 Shortcode', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_address_title]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_address_title'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_address_title]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Address Title', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_address]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_address'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_address]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Address', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_phone_title]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_phone_title'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_phone_title]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Phone Title', 'jewelry-store'),
					'section'     => 'contact_section',

				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_phone]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_phone'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_phone]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Phone', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_email_title]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_email_title'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_email_title]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Email Title', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);

			$wp_customize->add_setting( 'jewelrystore_option[contact_email]',
				array(
					'sanitize_callback' => 'wp_kses_post',
					'default'           => $option['contact_email'],
					'type' => 'option',
				)
			);
			$wp_customize->add_control( 'jewelrystore_option[contact_email]',
				array(
					'type'        => 'text',
					'label'       => esc_html__('Email', 'jewelry-store'),
					'section'     => 'contact_section',
				)
			);
}
add_action('customize_register','jewelry_store_customizer_contact');