<?php 
function jewelry_store_typography_setting( $wp_customize ){
	$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );
	
	$wp_customize->add_panel( 'jewelry_store_typography', array(
		'title'      => __('Typography', 'jewelry-store'),
		'capability'     => 'edit_theme_options',
		'priority'       => 33,
	) );

	// Body Section

	$wp_customize->add_section( 'body_section' , array(
		'title'      => __('Body Typography', 'jewelry-store'),
		'panel'      => 'jewelry_store_typography',
		'priority'   => 0,
	) );

	if ( class_exists( 'Jewelry_Store_Customizer_Range_Control' ) ) {

		// Font Size 
		$wp_customize->add_setting( 'jewelrystore_option[body_font_size]', array(
			'default'           => $option['body_font_size'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_range_value',
			'type' => 'option',
			'priority'   => 2,
		) );
		$wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[body_font_size]', 
			array(
				'label'      => __( 'Font Size', 'jewelry-store' ),
				'section'  => 'body_section',
				'media_query'   => true,
                'input_attr'    => array(
                    'mobile'  => array(
                        'min'           => 8,
                        'max'           => 50,
                        'step'          => 1,
                        'default_value' => $option['body_font_size'],
                    ),
                    'tablet'  => array(
                        'min'           => 8,
                        'max'           => 50,
                        'step'          => 1,
                        'default_value' => $option['body_font_size'],
                    ),
                    'desktop' => array(
                        'min'           => 8,
                        'max'           => 50,
                        'step'          => 1,
                        'default_value' => $option['body_font_size'],
                    ),
                ),
			) ) 
		);

		// Line height
		$wp_customize->add_setting( 'jewelrystore_option[body_line_height]', array(
			'default'           => $option['body_line_height'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_range_value',
			'type' => 'option',
			'priority'   => 3,
		) );
		$wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[body_line_height]', 
			array(
				'label'      => __( 'Line Height', 'jewelry-store' ),
				'section'  => 'body_section',
				'media_query'   => true,
                'input_attr'    => array(
                    'mobile'  => array(
                        'min'           => 1,
                        'max'           => 3,
                        'step'          => 0.1,
                        'default_value' => $option['body_line_height'],
                    ),
                    'tablet'  => array(
                        'min'           => 1,
                        'max'           => 3,
                        'step'          => 0.1,
                        'default_value' => $option['body_line_height'],
                    ),
                    'desktop' => array(
                        'min'           => 1,
                        'max'           => 3,
                        'step'          => 0.1,
                        'default_value' => $option['body_line_height'],
                    ),
                ),
			) ) 
		);

		// Letter Spacing
		$wp_customize->add_setting( 'jewelrystore_option[body_letter_spacing]', array(
			'default'           => $option['body_letter_spacing'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_range_value',
			'type' => 'option',
			'priority'   => 4,
		) );
		$wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[body_letter_spacing]', 
			array(
				'label'      => __( 'Letter Spacing', 'jewelry-store' ),
				'section'  => 'body_section',
				'media_query'   => true,
                'input_attr'    => array(
                    'mobile'  => array(
                        'min'           => -10,
                        'max'           => 10,
                        'step'          => 1,
                        'default_value' => $option['body_letter_spacing'],
                    ),
                    'tablet'  => array(
                        'min'           => -10,
                        'max'           => 10,
                        'step'          => 1,
                        'default_value' => $option['body_letter_spacing'],
                    ),
                    'desktop' => array(
                        'min'           => -10,
                        'max'           => 10,
                        'step'          => 1,
                        'default_value' => $option['body_letter_spacing'],
                    ),
                ),
			) ) 
		);
	}

	// Font Weight
	$wp_customize->add_setting( 'jewelrystore_option[body_font_weight]', array(
		'default'           => $option['body_font_weight'],
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'jewelry_store_sanitize_select',
		'type' => 'option',
		'priority'   => 5,
	) );
	$wp_customize->add_control( 'jewelrystore_option[body_font_weight]', array(
		'label'      => __( 'Font Weight', 'jewelry-store' ),
		'section'  => 'body_section',
        'type'        => 'select',
        'choices'     =>  array(
            'inherit'   =>  __( 'Default', 'jewelry-store' ),
            '100'       =>  __( 'Thin: 100', 'jewelry-store' ),
            '200'       =>  __( 'Light: 200', 'jewelry-store' ),
            '300'       =>  __( 'Book: 300', 'jewelry-store' ),
            '400'       =>  __( 'Normal: 400', 'jewelry-store' ),
            '500'       =>  __( 'Medium: 500', 'jewelry-store' ),
            '600'       =>  __( 'Semibold: 600', 'jewelry-store' ),
            '700'       =>  __( 'Bold: 700', 'jewelry-store' ),
            '800'       =>  __( 'Extra Bold: 800', 'jewelry-store' ),
            '900'       =>  __( 'Black: 900', 'jewelry-store' )
    ) ) );

    // Font Style
	$wp_customize->add_setting( 'jewelrystore_option[body_font_style]', array(
		'default'           => $option['body_font_style'],
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'jewelry_store_sanitize_select',
		'type' => 'option',
		'priority'   => 6,
	) );
	$wp_customize->add_control( 'jewelrystore_option[body_font_style]', array(
		'label'      => __( 'Font Style', 'jewelry-store' ),
		'section'  => 'body_section',
        'type'        => 'select',
        'choices'     =>  array(
            'inherit'   =>  __( 'Inherit', 'jewelry-store' ),
            'normal'       =>  __( 'Normal', 'jewelry-store' ),
            'italic'       =>  __( 'Italic', 'jewelry-store' ),
            'oblique'       =>  __( 'oblique', 'jewelry-store' ),
    ) ) );

    // Text Transform
	$wp_customize->add_setting( 'jewelrystore_option[body_text_transform]', array(
		'default'           => $option['body_text_transform'],
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'jewelry_store_sanitize_select',
		'type' => 'option',
		'priority'   => 7,
	) );
	$wp_customize->add_control( 'jewelrystore_option[body_text_transform]', array(
		'label'      => __( 'Text Transform', 'jewelry-store' ),
		'section'  => 'body_section',
        'type'        => 'select',
        'choices'     =>  array(
            'inherit'       =>  __( 'Default', 'jewelry-store' ),
            'uppercase'     =>  __( 'Uppercase', 'jewelry-store' ),
            'lowercase'     =>  __( 'Lowercase', 'jewelry-store' ),
            'capitalize'    =>  __( 'Capitalize', 'jewelry-store' ),
    ) ) );

    // Text Decoration
	$wp_customize->add_setting( 'jewelrystore_option[body_text_decoration]', array(
		'default'           => $option['body_text_decoration'],
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'jewelry_store_sanitize_select',
		'type' => 'option',
		'priority'   => 8,
	) );
	$wp_customize->add_control( 'jewelrystore_option[body_text_decoration]', array(
		'label'      => __( 'Text Decoration', 'jewelry-store' ),
		'section'  => 'body_section',
        'type'        => 'select',
        'choices'     =>  array(
            'inherit'       =>  __( 'Inherit', 'jewelry-store' ),
            'underline'     =>  __( 'Underline', 'jewelry-store' ),
            'overline'     =>  __( 'Overline', 'jewelry-store' ),
            'line-through'    =>  __( 'Line Through', 'jewelry-store' ),
			'none'    =>  __( 'None', 'jewelry-store' ),
    ) ) );

    // Headings Section

    $wp_customize->add_section( 'headings_section' , array(
		'title'      => __('Headings', 'jewelry-store'),
		'panel'      => 'jewelry_store_typography',
		'priority'   => 1,
	) );

	for( $i = 1; $i <= 6; $i++ ){

		$wp_customize->add_setting( 'h'.$i.'_typography', array(
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'sanitize_text_field',
				'priority'   => $i,
			)
		);
		$wp_customize->add_control('h'.$i.'_typography', array(
				'type'    => 'hidden',
				'label'   => sprintf(__('H%s','jewelry-store'),$i),
				'section' => 'headings_section',
		) );

		if ( class_exists( 'Jewelry_Store_Customizer_Range_Control' ) ) {

			// Font Size 
			$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_font_size]', array(
				'default'           => $option['h'.$i.'_font_size'],
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'jewelry_store_sanitize_range_value',
				'type' => 'option',
				'priority'   => $i,
			) );
			$wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[h'.$i.'_font_size]', 
				array(
					'label'      => __( 'Font Size', 'jewelry-store' ),
					'section'  => 'headings_section',
					'media_query'   => true,
	                'input_attr'    => array(
	                    'mobile'  => array(
	                        'min'           => 8,
	                        'max'           => 50,
	                        'step'          => 1,
	                        'default_value' => $option['h'.$i.'_font_size'],
	                    ),
	                    'tablet'  => array(
	                        'min'           => 8,
	                        'max'           => 50,
	                        'step'          => 1,
	                        'default_value' => $option['h'.$i.'_font_size'],
	                    ),
	                    'desktop' => array(
	                        'min'           => 8,
	                        'max'           => 50,
	                        'step'          => 1,
	                        'default_value' => $option['h'.$i.'_font_size'],
	                    ),
	                ),
				) ) 
			);

			// Line height
			$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_line_height]', array(
				'default'           => $option['h'.$i.'_line_height'],
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'jewelry_store_sanitize_range_value',
				'type' => 'option',
				'priority'   => $i,
			) );
			$wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[h'.$i.'_line_height]', 
				array(
					'label'      => __( 'Line Height', 'jewelry-store' ),
					'section'  => 'headings_section',
					'media_query'   => true,
	                'input_attr'    => array(
	                    'mobile'  => array(
	                        'min'           => 1,
	                        'max'           => 3,
	                        'step'          => 0.1,
	                        'default_value' => $option['h'.$i.'_line_height'],
	                    ),
	                    'tablet'  => array(
	                        'min'           => 1,
	                        'max'           => 3,
	                        'step'          => 0.1,
	                        'default_value' => $option['h'.$i.'_line_height'],
	                    ),
	                    'desktop' => array(
	                        'min'           => 1,
	                        'max'           => 3,
	                        'step'          => 0.1,
	                        'default_value' => $option['h'.$i.'_line_height'],
	                    ),
	                ),
				) ) 
			);

			// Letter Spacing
			$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_letter_spacing]', array(
				'default'           => $option['h'.$i.'_letter_spacing'],
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'jewelry_store_sanitize_range_value',
				'type' => 'option',
				'priority'   => $i,
			) );
			$wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[h'.$i.'_letter_spacing]', 
				array(
					'label'      => __( 'Letter Spacing', 'jewelry-store' ),
					'section'  => 'headings_section',
					'media_query'   => true,
	                'input_attr'    => array(
	                    'mobile'  => array(
	                        'min'           => -10,
	                        'max'           => 10,
	                        'step'          => 1,
	                        'default_value' => $option['h'.$i.'_letter_spacing'],
	                    ),
	                    'tablet'  => array(
	                        'min'           => -10,
	                        'max'           => 10,
	                        'step'          => 1,
	                        'default_value' => $option['h'.$i.'_letter_spacing'],
	                    ),
	                    'desktop' => array(
	                        'min'           => -10,
	                        'max'           => 10,
	                        'step'          => 1,
	                        'default_value' => $option['h'.$i.'_letter_spacing'],
	                    ),
	                ),
				) ) 
			);
		}

		// Font Weight
		$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_font_weight]', array(
			'default'           => $option['h'.$i.'_font_weight'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_select',
			'type' => 'option',
			'priority'   => $i,
		) );
		$wp_customize->add_control( 'jewelrystore_option[h'.$i.'_font_weight]', array(
			'label'      => __( 'Font Weight', 'jewelry-store' ),
			'section'  => 'headings_section',
	        'type'        => 'select',
	        'choices'     =>  array(
	            'inherit'   =>  __( 'Default', 'jewelry-store' ),
	            '100'       =>  __( 'Thin: 100', 'jewelry-store' ),
	            '200'       =>  __( 'Light: 200', 'jewelry-store' ),
	            '300'       =>  __( 'Book: 300', 'jewelry-store' ),
	            '400'       =>  __( 'Normal: 400', 'jewelry-store' ),
	            '500'       =>  __( 'Medium: 500', 'jewelry-store' ),
	            '600'       =>  __( 'Semibold: 600', 'jewelry-store' ),
	            '700'       =>  __( 'Bold: 700', 'jewelry-store' ),
	            '800'       =>  __( 'Extra Bold: 800', 'jewelry-store' ),
	            '900'       =>  __( 'Black: 900', 'jewelry-store' )
	    ) ) );

	    // Font Style
		$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_font_style]', array(
			'default'           => $option['h'.$i.'_font_style'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_select',
			'type' => 'option',
			'priority'   => $i,
		) );
		$wp_customize->add_control( 'jewelrystore_option[h'.$i.'_font_style]', array(
			'label'      => __( 'Font Style', 'jewelry-store' ),
			'section'  => 'headings_section',
	        'type'        => 'select',
	        'choices'     =>  array(
	            'inherit'   =>  __( 'Inherit', 'jewelry-store' ),
	            'normal'       =>  __( 'Normal', 'jewelry-store' ),
	            'italic'       =>  __( 'Italic', 'jewelry-store' ),
	            'oblique'       =>  __( 'oblique', 'jewelry-store' ),
	    ) ) );

	    // Text Transform
		$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_text_transform]', array(
			'default'           => $option['h'.$i.'_text_transform'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_select',
			'type' => 'option',
			'priority'   => $i,
		) );
		$wp_customize->add_control( 'jewelrystore_option[h'.$i.'_text_transform]', array(
			'label'      => __( 'Text Transform', 'jewelry-store' ),
			'section'  => 'headings_section',
	        'type'        => 'select',
	        'choices'     =>  array(
	            'inherit'       =>  __( 'Default', 'jewelry-store' ),
	            'uppercase'     =>  __( 'Uppercase', 'jewelry-store' ),
	            'lowercase'     =>  __( 'Lowercase', 'jewelry-store' ),
	            'capitalize'    =>  __( 'Capitalize', 'jewelry-store' ),
	    ) ) );

	    // Text Decoration
		$wp_customize->add_setting( 'jewelrystore_option[h'.$i.'_text_decoration]', array(
			'default'           => $option['h'.$i.'_text_decoration'],
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'jewelry_store_sanitize_select',
			'type' => 'option',
			'priority'   => $i,
		) );
		$wp_customize->add_control( 'jewelrystore_option[h'.$i.'_text_decoration]', array(
			'label'      => __( 'Text Decoration', 'jewelry-store' ),
			'section'  => 'headings_section',
	        'type'        => 'select',
	        'choices'     =>  array(
	            'inherit'       =>  __( 'Inherit', 'jewelry-store' ),
	            'underline'     =>  __( 'Underline', 'jewelry-store' ),
	            'overline'     =>  __( 'Overline', 'jewelry-store' ),
	            'line-through'    =>  __( 'Line Through', 'jewelry-store' ),
				'none'    =>  __( 'None', 'jewelry-store' ),
	    ) ) );
	}
}
add_action( 'customize_register', 'jewelry_store_typography_setting', 30 );