<?php 
$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

$containerClass = '';
if($option['contact_container_width']!=''){
    $containerClass = $option['contact_container_width'];
}

if($option['contact_enable']==true){
?>
<div id="contact" class="section contact_section">
    <div class="<?php echo esc_attr( $containerClass ); ?>">
        <?php if( $option['contact_subtitle'] != '' || $option['contact_title'] != '' || $option['contact_desc'] != '' ){ ?>
        <div class="row">
            <div class="col-12">
                <div class="header_section wow animated fadeInUp">
                    <div class="header_section_container">
                        <div class="header_section_details">
                            <?php if( $option['contact_subtitle'] != '' || $option['contact_title'] != '' ){ ?>
                                <h2 class="section_title_wrap">
                                    <?php if( $option['contact_subtitle'] != '' ){ ?>
                                    <span class="section_subtitle"><?php echo wp_kses_post($option['contact_subtitle']); ?></span>
                                    <?php } ?>
                                    <?php if( $option['contact_title'] != '' ){ ?>
                                    <span class="section_title"><?php echo wp_kses_post($option['contact_title']); ?></span>
                                    <?php } ?>
                                </h2>
                            <?php } ?>
                            <?php if($option['contact_desc']!=''){ ?>
                                <p class="section_desc"><?php echo wp_kses_post($option['contact_desc']); ?></p>
                            <?php } ?>
                        </div>                          
                    </div>
                </div>
            </div>                    
        </div>
        <?php } ?>
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10 col-12">
                <div class="contact_section_form wow animated fadeInUp">
                  <?php echo do_shortcode( $option['contact_shortcode'] ); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="contact_bottom">
        <div class="<?php echo esc_attr( $containerClass ); ?>">
            <div class="row wow animated fadeInUp">
                <div class="col-lg-4 col-md-4 col-12">
                    <div class="contact_info">
                        <span class="contact_info_icon">
                            <i class="fa fa-map"></i>
                        </span>
                        <div class="contact_info_content">
                            <h5 class="contact_info_title"><?php echo esc_html( $option['contact_address_title'] ); ?></h5>
                            <p class="contact_info_desc"><?php echo esc_html( $option['contact_address'] ); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-12">
                    <div class="contact_info">
                        <span class="contact_info_icon">
                            <i class="fa fa-phone"></i>
                        </span>
                        <div class="contact_info_content">
                            <h5 class="contact_info_title"><?php echo esc_html( $option['contact_phone_title'] ); ?></h5>
                            <p class="contact_info_desc"><?php echo esc_html( $option['contact_phone'] ); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-4 col-12">
                    <div class="contact_info">
                        <span class="contact_info_icon">
                            <i class="fa fa-envelope"></i>
                        </span>
                        <div class="contact_info_content">
                            <h5 class="contact_info_title"><?php echo esc_html( $option['contact_email_title'] ); ?></h5>
                            <p class="contact_info_desc"><?php echo esc_html( $option['contact_email'] ); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>