<?php
/**
 * Template part for displaying no post page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package jewelry-store
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('theme_post'); ?>>

    <header class="entry-header">
        <h2 class="entry-title">
            <?php _e( 'Nothing Found', 'jewelry-store' ); ?>
        </h2>
    </header><!-- .entry-header -->

    <div class="entry-content">        
        <?php
        if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
            <p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'jewelry-store' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
        <?php else : ?>
            <p><?php _e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'jewelry-store' ); ?></p>
            <?php
                get_search_form();
        endif; ?>
    </div>
    
</article><!-- #post-## -->