<?php
/**
 * Template part for displaying post type page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package jewelry-store
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('theme_post'); ?>>
    
    <?php if ( '' !== get_the_post_thumbnail() ) : ?>
    <div class="post_thumbnail">
        <?php the_post_thumbnail( 'full' ); ?>
    </div>
    <?php endif; ?>

    <header class="entry-header">
        <?php 
            if ( is_page() ) {
                the_title( '<h1 class="entry-title">', '</h1>' );
            } else {
                the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
            } 
        ?>
    </header><!-- .entry-header -->

    <div class="entry-content">
        <?php

        the_content( 
                    sprintf( 
                        __( 'Read More', 'jewelry-store' ), 
                        '<span class="screen-reader-text">  '.esc_html(get_the_title()).'</span>' 
                    ) 
                );

        ?>
    </div>

     <footer class="entry-footer">
        <?php jewelry_store_entry_footer(); ?>
    </footer><!-- .entry-footer -->
    
</article><!-- #post-## -->