<?php
$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

$navbar_class = '';

if( is_front_page() ){
  $is_transparent_nav = $option['navigation_transparent'] ? $option['navigation_transparent'] : false;
  if($is_transparent_nav){
    $navbar_class .= 'is_transparent';
  }
}

$is_header_sticky = $option['navigation_sticky']?$option['navigation_sticky']:false;
if($is_header_sticky){
  $navbar_class .= ' is_sticky';
}

$containerClass = '';
if($option['navigation_container_width']!=''){
    $containerClass = $option['navigation_container_width'];
}
?>
<nav class="main_navigation <?php echo esc_attr( $navbar_class ); ?> d-lg-block d-md-none d-none">
  <div class="<?php echo esc_attr( $containerClass ); ?>">
      <div class="row align-items-center">
        <div class="col-lg-3 col-md-3 col-12">
          <div class="header_logo">
              <?php 
              // Main theme logo
              jewelry_store_logo();
              ?>
          </div>
        </div>
        <div class="col-lg-9 col-md-9 col-12 d-flex justify-content-end">
          <nav class="navbar">
            <?php 
            if ( has_nav_menu( 'primary' ) ) :  
              wp_nav_menu( array(
              'theme_location' => 'primary',
              'menu_class' => 'main_menu',
              'container' => 'ul',
              ) );
            else: 
              wp_nav_menu( array(
              'theme_location' => 'primary',
              'menu_class' => 'main_menu',
              'container' => 'ul',
              ) );
            endif; 

            $option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );
            if( class_exists('woocommerce') ){
            ?>
            <ul class="main_menu_right">
              <?php 
              global $woocommerce;

              if( is_user_logged_in() ){
                $user_account_link = wp_logout_url( home_url() );
                $user_account_icon = 'fa fa-sign-out';
                $user_account_title = sprintf(__('Logout','jewelry-store'));
              }else{
                $user_account_link = get_permalink( get_option('woocommerce_myaccount_page_id') );
                $user_account_icon = 'fa fa-user-circle-o';
                $user_account_title = sprintf(__('Login','jewelry-store'));
              }

              if( $option['navigation_account_icon'] == true ){
              ?>
              <li class="account">
                <a href="<?php echo esc_url( $user_account_link ); ?>" title="<?php echo esc_attr( $user_account_title ); ?>">
                  <i class="<?php echo esc_attr( $user_account_icon ); ?>"></i>
                </a>
              </li>
              <?php } ?>
              
              <?php 
              if( class_exists( 'YITH_WCWL' ) && function_exists('is_pro') && $option['navigation_wishlist_icon'] == true ) { 
                if ( defined( 'YITH_WCWL' ) ) {
                  $fav_count =  yith_wcwl_count_all_products();
                  if ( $fav_count > 0 ) {
                    $fav_value = $fav_count;
                  }else{
                    $fav_value = 0;
                  }
              ?>
              <li class="favorite">
                <a class="favorite-total" href="<?php echo esc_url( YITH_WCWL()->get_wishlist_url() ); ?>" title="<?php echo esc_attr($option['navigation_wishlist_title']); ?>">
                  <i class="fa fa-heart-o"></i>
                  <span class="favorite-value"><?php echo esc_html( $fav_value ); ?></span>
                </a>
              </li>
              <?php } } ?>

              <?php 
              if( function_exists('yith_woocompare_constructor') && function_exists('is_pro') && $option['navigation_compare_icon'] == true ){
              global $yith_woocompare;
              $yith_compare_text = get_option( 'yith_woocompare_button_text' );
              ?>
              <li class="compare">
                <a class="compare-total" href="<?php echo esc_url( $yith_woocompare->obj->view_table_url() ); ?>" title="<?php echo esc_attr($option['navigation_compare_title']); ?>">
                  <i class="fa fa-exchange"></i>
                  <span class="compare-value"><?php echo wp_kses_post(count($yith_woocompare->obj->products_list)); ?></span>
                </a>
              </li>
              <?php } ?>

              <?php
              if ( isset($option['navigation_cart_icon']) && $option['navigation_cart_icon'] == true ) {
              ?>
              <li class="nav_cart_counts">
                <div class="cart-total">
                  <i class="fa fa-shopping-cart"></i>
                  <span class="cart-value"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                </div>
                <div class="shopping_cart">
                  <?php woocommerce_mini_cart(); ?>
                </div>
              </li>
              <?php } ?>
            </ul>
            <?php } ?>
          </nav>
        </div>
      </div>                 
  </div>
</nav>
<?php 
// $navbar_class = str_replace(' is_sticky','',$navbar_class);
?>
<div class="mobile-menus <?php echo esc_attr( $navbar_class ); ?> d-lg-none d-md-block d-block">
  <div class="<?php echo esc_attr( $containerClass ); ?>">
    <div class="row">
      <div class="col-12">
        <div class="mobile-menu-inner">
          <div class="site-logo">
            <?php 
            // Main theme logo
            jewelry_store_logo();
            ?>
          </div>
          <button class="btn mobile-menu-target" data-mobile-menu-target="#mobile-menu-container"><i class="fa fa-bars"></i></button>
        </div>
        <div id="mobile-menu-container" class="mobile-menu-container">
          <div class="mobile-menu-container-overlay"></div>
          <div class="mobile-menu-container-inner">
            <div class="mobile-menu-logo">
              <div class="site-logo">
                <?php 
                // Main theme logo
                jewelry_store_logo();
                ?>
              </div>
            </div>
            <nav class="mobile-menu">
              <?php 
              if ( has_nav_menu( 'primary' ) ) :  
                wp_nav_menu( array(
                'theme_location' => 'primary',
                'menu_class' => 'main-menu-list',
                'container' => 'ul',
                ) );
              else: 
                wp_nav_menu( array(
                'theme_location' => 'primary',
                'menu_class' => 'main-menu-list',
                'container' => 'ul',
                ) );
              endif; 
              ?>
            </nav>
          </div>
          <button class="btn btn-close mobile-menu-close" mobile-menu-close><i class="fa fa-times"></i></button>
        </div>
      </div>
    </div>
  </div>
</div><!-- .mobile-menus -->