<?php
/**
 * The template for displaying product content within loops
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
$columns = wc_get_loop_prop('columns');
if (1 == $columns) {
    $grid = '12';
}
elseif (2 == $columns) {
    $grid = '6';
}
elseif (3 == $columns) {
    $grid = '4';
}
elseif (4 == $columns) {
    $grid = '3';
}
else {
    $grid = '2';
}
?>

<?php
$terms = get_the_terms($post->ID,'product_cat');
//if (is_array($terms) && count($terms) == 1) {
if (is_array($terms) && count($terms)) {
	$count = count($terms);
}else{
	$count = 0;
}
$i=0;
if ($count > 0) {
    $term_list = '';
    foreach ($terms as $term) {
        $i++;
        if ($term->parent==0) {
			$term_list .= str_replace(' ', '-', strtolower($term->name));
            if ($count != $i) $term_list .= ' ';
        }
    }
?>
<li <?php wc_product_class( strtolower($term_list).'', $product ); ?>>
<?php  } else { ?>
<li <?php wc_product_class( '', $product ); ?>>
<?php } ?>
	<div class="product">
		<div class="product_single">
			<div class="product_bg"></div>
			<div class="product_thumbnail">
				<?php
				/**
				 * Hook: woocommerce_before_shop_loop_item.
				 *
				 * @hooked woocommerce_template_loop_product_link_open - 10
				 */
				do_action( 'woocommerce_before_shop_loop_item' );
				?>
				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail(); ?>
				</a>
				<?php if ( $product->is_on_sale() ) : ?>

				<?php echo apply_filters( 'woocommerce_sale_flash', '<div class="sale_ribbon"><span class="tag_line">' . esc_html__( 'Sale', 'jewelry-store' ) . '</span></div>', $post, $product ); ?>
				<?php endif; ?>

				<?php 
				// Quick View Button
				if( function_exists('yith_wcqv_init') && function_exists('is_pro') ){
					$quickview_button = '<a href="#" class="yith-wcqv-button" data-product_id="' . esc_attr( $product->get_id() ) . '"><i class="fa fa-eye"></i></a>';
					echo wp_kses_post($quickview_button);
				}

				// attachment images
				$attachment_ids = $product->get_gallery_image_ids();
				if(!empty($attachment_ids)):
						foreach( $attachment_ids as $i=> $attachment_id ) {
						$image_url2 = wp_get_attachment_url( $attachment_id );
						if($i==0){
				?>
					<a href="<?php the_permalink(); ?>">
						<img width="800" height="800" src="<?php  echo esc_url($image_url2); ?>" class="product_single_effect_img" alt="" />
					</a>
				<?php }  
				} 
				else: ?>
					<a href="<?php the_permalink(); ?>">
						<img width="800" height="800" src="<?php the_post_thumbnail_url(); ?>" class="product_single_effect_img" alt="" />
					</a>
				<?php endif; ?>
			</div>
			<div class="product_content_outer">
				<div class="product_content">					
					<h3 class="product_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
					<div class="product_rating">
						<?php if ($average = $product->get_average_rating()) : ?>
						<?php echo '<div class="star-rating" title="'.sprintf(__( 'Rated %s out of 5', 'jewelry-store' ), $average).'"><span style="width:'.( ( $average / 5 ) * 100 ) . '%"><strong itemprop="ratingValue" class="rating">'.$average.'</strong> '.__( 'out of 5', 'jewelry-store' ).'</span></div>'; ?>
						<?php endif; ?>
					</div>
					<div class="product_price">
						<?php echo $product->get_price_html(); ?>
					</div>
				</div>
				<div class="product_actions">			
					<?php

					/**
					 * Hook: woocommerce_after_shop_loop_item.
					 *
					 * @hooked woocommerce_template_loop_product_link_close - 5
					 * @hooked woocommerce_template_loop_add_to_cart - 10
					 */
					if( class_exists( 'YITH_WCWL' ) && function_exists('is_pro') ) { 

						echo do_shortcode( '[yith_wcwl_add_to_wishlist]' ); 

					}

					do_action( 'woocommerce_after_shop_loop_item' );
					?>
				</div>
			</div>
		</div>
	</div>
</li>